% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-handler.R
\name{new_output_handler}
\alias{new_output_handler}
\alias{output_handler}
\title{Custom output handlers}
\usage{
new_output_handler(
  source = identity,
  text = identity,
  graphics = identity,
  message = identity,
  warning = identity,
  error = identity,
  value = render,
  calling_handlers = list()
)
}
\arguments{
\item{source}{Function to handle the echoed source code under evaluation.
This function should take two arguments (\code{src} and \code{expr}), and return
an object that will be inserted into the evaluate outputs. \code{src} is the
unparsed text of the source code, and \code{expr} is the complete input
expression (which may have 0, 1, 2, or more components; see \code{\link[=parse_all]{parse_all()}}
for details).

Return \code{src} for the default evaluate behaviour. Return \code{NULL} to
drop the source from the output.}

\item{text}{Function to handle any textual console output.}

\item{graphics}{Function to handle graphics, as returned by
\code{\link[=recordPlot]{recordPlot()}}.}

\item{message}{Function to handle \code{\link[=message]{message()}} output.}

\item{warning}{Function to handle \code{\link[=warning]{warning()}} output.}

\item{error}{Function to handle \code{\link[=stop]{stop()}} output.}

\item{value}{Function to handle the values returned from evaluation.
\itemize{
\item If it has one argument, it called on visible values.
\item If it has two arguments, it handles all values, with the second
argument indicating whether or not the value is visible.
\item If it has three arguments, it will be called on all values, with the
the third argument given the evaluation environment which is needed
to look up print methods for S3 objects.
}}

\item{calling_handlers}{List of \link[=withCallingHandlers]{calling handlers}.
These handlers have precedence over the exiting handler installed
by \code{\link[=evaluate]{evaluate()}} when \code{stop_on_error} is set to 0.}
}
\value{
A new \code{output_handler} object
}
\description{
An \code{output_handler} handles the results of \code{\link[=evaluate]{evaluate()}},
including the values, graphics, conditions. Each type of output is handled by
a particular function in the handler object.
}
\details{
The handler functions should accept an output object as their first argument.
The return value of the handlers is ignored, except in the case of the
\code{value} handler, where a visible return value is saved in the output
list.

Calling the constructor with no arguments results in the default handler,
which mimics the behavior of the console by printing visible values.

Note that recursion is common: for example, if \code{value} does any
printing, then the \code{text} or \code{graphics} handlers may be called.
}
