% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{read_quantitative_inputs}
\alias{read_quantitative_inputs}
\title{Load quantitative inputs}
\usage{
read_quantitative_inputs(input_directory = "~/evaluator/inputs")
}
\arguments{
\item{input_directory}{Location of input files.}
}
\value{
List of domains, quantitative_scenarios, and risk_tolerances
}
\description{
Given an input directory, load the quantitative objects into memory.
}
\details{
The key quantitative inputs for Evaluator processing include:
\itemize{
\item \code{domains.csv} - domains and domain_ids
\item \code{risk_tolerances.csv} - the risk tolerances of the organization
\item \code{quantitative_scenarios.rds} - risk scenarios and quantified parameters
}
}
\examples{
\dontrun{
read_quantitative_inputs("~/evaluator/inputs")
}
}
