% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.credpart.R
\name{summary.credpart}
\alias{summary.credpart}
\title{Summary of a credal partition}
\usage{
\method{summary}{credpart}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"credpart"}, encoding a credal partition.}

\item{...}{Additional arguments (not used).}
}
\value{
Prints basic information on the credal partition.
}
\description{
\code{summary.credpart} is the \code{summary} method for \code{"credpart"} objects.
}
\details{
This function extracts basic information from \code{"credpart"} objects, such as created by
\code{\link{ecm}}, \code{\link{recm}}, \code{\link{cecm}}, \code{\link{EkNNclus}}or
 \code{\link{kevclus}}.
}
\examples{
## Example with Four-class data
data("fourclass")
x<-fourclass[,1:2]
y<-fourclass[,3]
c=4
## Running k-EVCLUS with singletons
clus<-kevclus(x=x,k=100,c=c,type='simple')
summary(clus)
}
\references{
T. Denoeux and O. Kanjanatarakul. Beyond Fuzzy, Possibilistic and Rough: An
Investigation of Belief Functions in Clustering. 8th International conference on soft
methods in probability and statistics, Rome, 12-14 September, 2016.

M.-H. Masson and T. Denoeux. ECM: An evidential version of the fuzzy c-means algorithm.
Pattern Recognition, Vol. 41, Issue 4, pages 1384--1397, 2008.

T. Denoeux, S. Sriboonchitta and O. Kanjanatarakul. Evidential clustering of large
dissimilarity data. Knowledge-Based Systems, vol. 106, pages 179-195, 2016.

Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}
\seealso{
\code{\link{extractMass}}, \code{\link{plot.credpart}}, \code{\link{ecm}},
\code{\link{recm}}, \code{\link{cecm}}, \code{\link{EkNNclus}}, \code{\link{kevclus}}.
}
