% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harris.R
\name{harris}
\alias{harris}
\title{Harris gradient-based optimization algorithm}
\usage{
harris(fun, x, options = c(1, 100, 1e-04, 10), tr = FALSE, ...)
}
\arguments{
\item{fun}{Function to be optimized. The function 'fun' should return a scalar function value 'fun' 
and a vector 'grad' containing the partial derivatives of fun at x.}

\item{x}{Initial value (a vector).}

\item{options}{Vector of parameters (see details).}

\item{tr}{If TRUE, returns a trace of objective function vs CPU time}

\item{...}{Additional parameters passed to fun}
}
\value{
A list with three attributes:
 \describe{
  \item{par}{The minimizer of fun found.}
  \item{value}{The value of fun at par.}
  \item{trace}{The trace, a list with two attributes: 'time' and 'fct' (if tr==TRUE).}
 }
}
\description{
The optimization algorithm implemented in \code{harris} is described on Silva & Almeida (1990) and
summarized in Denoeux & Masson (2004). The four parameters are:
\describe{
  \item{options[1]}{Display parameter : 1 (default) displays some results.}
  \item{options[2]}{Maximum number of iterations (default: 100).}
  \item{options[3]}{Relative error for stopping criterion (default: 1e-4).}
  \item{options[4]}{Number of iterations between two displays.}
 }
}
\examples{
opt<-harris(function(x) return(list(fun=sum(x^2),grad=2*x)),rnorm(2),tr=TRUE)
print(c(opt$par,opt$value))
plot(opt$trace$fct,type="l")

}
\references{
F. M. Silva and L. B. Almeida. Speeding up backpropagation. In Advanced Neural 
Computers, R. Eckmiller, ed., Elsevier-North-Holland, New-York, 151-158, 1990.

T. Denoeux and M.-H. Masson. EVCLUS: Evidential Clustering of Proximity Data.
IEEE Transactions on Systems, Man and Cybernetics B, Vol. 34, Issue 1, 95--109, 2004.
}
\seealso{
\code{\link{pcca}}
}
\author{
Thierry Denoeux.
}
