% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.surface.GRW.R
\name{loglik.surface.GRW}
\alias{loglik.surface.GRW}
\title{Calculate the log-likelihood surface for a part of parameter space}
\usage{
loglik.surface.GRW(y, mstep.vec, vstep.vec, pool = TRUE)
}
\arguments{
\item{y}{an univariate paleoTS object.}

\item{mstep.vec}{vector containing the parameter values of the mstep parameter to be evaluated}

\item{vstep.vec}{vector containing the parameter values of the variance parameter to be evaluated}

\item{pool}{indicating whether to pool variances across samples}
}
\value{
the function returns the range of parameter values that are within two log-likelihood units from the best (maximum) parameter estimate and a log-likelihood surface.
}
\description{
Function to calculate the log-likelihood surface for a part of parameter space for a General Random Walk.
}
\note{
How fine-scaled the estimated log-likelihood surface is depends on the step size between the values in the input-vectors. The step-size therefore determines how accurate the representation of the support surface is, including the returned upper and lower estimates printed in the console. The range of the input vectors needs to be increased if the confidence interval includes the boundary of the input vector. Note also that it might be wise to include the maximum likelihood estimates as part of the input vectors. The computed support surface is conditional on the best estimates of the other model parameters that are not part of the support surface (e.g. the estimated ancestral trait value).
}
\examples{

## Generate a paleoTS objects
x <- paleoTS::sim.GRW(30)

## Fit the the model to the data.
x1<-paleoTS::opt.joint.GRW(x)

\donttest{
## Create log-likelihood surface (the example may take > 5 seconds to run)
loglik.surface.GRW(x, mstep.vec= seq(0,0.3,0.01), vstep.vec = seq(0,0.3,0.01))
}
}
\author{
Kjetil Lysne Voje
}
