% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response_d1classic}
\alias{response_d1classic}
\title{Generating a binary response function based on the EWOC classic model}
\usage{
response_d1classic(rho, mtd, theta, min_dose, max_dose)
}
\arguments{
\item{rho}{a numerical value indicating the true value of the parameter rho.}

\item{mtd}{a numerical value indicating the true value of the parameter mtd.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}
}
\value{
A function with dose as an input and a Binomial variable based on the
parameters as an output.
}
\description{
Generating a binary response function based on the EWOC classic model
}
\examples{
response_sim <- response_d1classic(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
response_sim(20)

}
