% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operating_characteristics.R
\name{mtd_bias}
\alias{mtd_bias}
\title{Bias of the MTD estimates}
\usage{
mtd_bias(mtd_estimate, true_mtd)
}
\arguments{
\item{mtd_estimate}{a numerical vector of the MTD estimates.}

\item{true_mtd}{a numerical value of the true Maximum Tolerable Dose.}
}
\value{
Bias of the MTD estimates.
}
\description{
Calculate the bias.
}
\examples{
\dontshow{
DLT <- 0
dose <- 30
step_zero <- ewoc_d1classic(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
response_sim <- response_d1classic(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- trial_simulation(step_zero = step_zero,
                       n_sim = 1, sample_size = 2,
                       alpha_strategy = "increasing",
                       response_sim = response_sim)
mtd_bias(sim$mtd_sim, true_mtd = 20)
}

\dontrun{
DLT <- 0
dose <- 30
step_zero <- ewoc_d1classic(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
response_sim <- response_d1classic(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- trial_simulation(step_zero = step_zero,
                       n_sim = 2, sample_size = 30,
                       alpha_strategy = "increasing",
                       response_sim = response_sim)
mtd_bias(sim$mtd_sim, true_mtd = 20)
}

}
