% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdlt.R
\name{pdlt_d1ph}
\alias{pdlt_d1ph}
\title{Generating a probability of DLT function based on the EWOC Proportional Hazards model}
\usage{
pdlt_d1ph(rho, mtd, shape = NULL, theta, min_dose, max_dose, tau,
  distribution)
}
\arguments{
\item{rho}{a numerical value indicating the true value of the parameter rho.}

\item{mtd}{a numerical value indicating the true value of the parameter mtd.}

\item{shape}{a numerical value indicating the true value of the parameter shape.
It is only necessary if 'distribution' = "weibull".}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}

\item{tau}{a numerical value defining the period of time for a possible
toxicity be observed.}

\item{distribution}{a character establishing the distribution for the time of
events.}
}
\value{
A function with dose as an input and a probability based on the
logistic regression and parameters as an output.
}
\description{
Generating a probability of DLT function based on the EWOC Proportional Hazards model
}
\examples{
pdlt <- pdlt_d1ph(rho = 0.05, mtd = 40, theta = 0.33,
                 min_dose = 30, max_dose = 50,
                 tau = 10, distribution = "exponential")
pdlt(40)

}
