% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response_d1extended}
\alias{response_d1extended}
\title{Generating a binary response function based on the EWOC extended model}
\usage{
response_d1extended(rho, min_dose, max_dose)
}
\arguments{
\item{rho}{a numerical vector indicating the true value of the parameters
rho_0 and rho_1.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}
}
\value{
A function with dose as an input and a Binomial variable based on the
parameters as an output.
}
\description{
Generating a binary response function based on the EWOC extended model
}
\examples{
response_sim <- response_d1extended(rho = c(0.05, 0.5),
                                   min_dose = 10, max_dose = 50)
response_sim(20)

}
