% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{ItemEntropy}
\alias{ItemEntropy}
\title{Item Entropy}
\usage{
ItemEntropy(U, na = NULL, Z = NULL, w = NULL, ...)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{...}{Internal parameters for maintaining compatibility with the binary data
processing system. Not intended for direct use.}
}
\value{
A numeric vector of entropy values for each item, measured in bits.
Values range from 0 to 1, where:
\itemize{
\item 1: maximum uncertainty (p = 0.5)
\item 0: complete certainty (p = 0 or 1)
\item Values near 1 indicate items with balanced response patterns
\item Values near 0 indicate items with extreme response patterns
}
}
\description{
The item entropy is an indicator of the variability or randomness
of the responses. This function is applicable only to binary response data.

The entropy value represents the uncertainty or information content of the
response pattern for each item, measured in bits. Maximum entropy (1 bit)
occurs when correct and incorrect responses are equally likely (p = 0.5).
}
\details{
The item entropy is calculated as:
\deqn{e_j = -p_j\log_2p_j-(1-p_j)\log_2(1-p_j)}
where \eqn{p_j} is the correct response rate for item j.

The entropy value has the following properties:
\itemize{
\item Maximum value of 1 bit when p = 0.5 (most uncertainty)
\item Minimum value of 0 bits when p = 0 or 1 (no uncertainty)
\item Higher values indicate more balanced response patterns
\item Lower values indicate more predictable response patterns
}
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# using sample dataset
ItemEntropy(J5S10)

}
