% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{make_test_shell}
\alias{make_test_shell}
\title{Make the shell of a \code{test_that} test.}
\usage{
make_test_shell(example_block, desc = "", e_e = TRUE)
}
\arguments{
\item{example_block}{A character vector of the lines in the examples of a
function's documentation.}

\item{desc}{To be the \code{desc} argument of the \code{\link[testthat:test_that]{testthat::test_that()}} call.}

\item{e_e}{Set this to \code{FALSE} to prevent anything from being put in the
shell of an \code{expect_equal()} statement.}
}
\value{
A character vector giving the shell of a \code{test_that} function call
testing all of the calls in the example block.
}
\description{
Given a character vector of the examples from a function, create the shell of
a \code{\link[testthat:test_that]{testthat::test_that()}} code block (to be filled in by the user) based upon
those examples.
}
\details{
Assignment lines (lines with \code{<-}, or even an \code{=} assignment (naughty, I
know)) and lines starting with \code{print(}, \code{stop(}, \code{warning(}, \code{setwd(},
\code{plot(}, \code{ggplot(}, \code{set.seed} or \code{library(} are left alone, others are put
in the shell of an \code{expect_equal()} statement. To prevent anything from being
put in the shell of an \code{expect_equal()} statement, set \code{e_e = FALSE}.
Anything found within a \code{\\dontrun\{...\}} block is ignored.
}
\examples{
setwd(tempdir())
devtools::create("tempkg")
setwd("tempkg")
file.copy(system.file("extdata", c("exemplar.R", "exampletestr.R"),
                      package = "exampletestr"), "R")
devtools::document()
exampletestr::make_test_shell(exampletestr::extract_examples("exemplar")[[1]])
exampletestr::make_test_shell(exampletestr::extract_examples("exemplar")[[1]],
                              desc = "xyz", e_e = FALSE)
setwd("..")
filesstrings::dir.remove("tempkg")

}
