% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_data.R
\name{add_data}
\alias{add_data}
\title{Vector Data Addition}
\usage{
add_data(x, box, n = c(0, 1), range = c(0, 1))
}
\arguments{
\item{x}{numeric: data vector}

\item{box}{character or numeric: a basic box is used}

\item{n}{numeric: number of  data values on the left, the right, or both sides of \code{x} (default: \code{c(0,1)})}

\item{range}{numeric: determines the range where the additional data values will be drawn from (default: \code{c(0,1)})}
}
\value{
a data vector with new values
}
\description{
Adds data values to a given data vector \code{x}.
}
\details{
Based on the data \code{x}, or the \code{range(box)}, a box is computed.
The length of the box gives the multiplier for the \code{range}.
Then a left and right interval, from which the additional values are drawn uniformly, is computed:
\eqn{[left box value-range[2]*box length; left box value-range[1]*box length]} (left interval) and
\eqn{[right box value+range[1]*box length; right box value+range[2]*box length]} (right interval).

For \code{box}, \code{"boxplot"} can be also used and \code{quantile(x, c(0.25, 0.75), na.rm=TRUE)} can be used instead of
\code{range(x, na.rm=TRUE)}.

\code{n} can be a single number which will add \code{n} data values at the right side of \code{x}.
If \code{n} is a vector of length two, then \code{n[1]} data values will be added at the left side of \code{x} and
\code{n[2]} data values will be added at the right side of \code{x}.
}
\examples{
x <- rnorm(8)
# add one value to the right
add_data(x, "box", range=1.5)
add_data(x, "range", range=0.1)
add_data(x, "box", range=c(1.5, 3))
# add two values to the right
add_data(x, "range", n=2, range=0.1)
# add two values to the left and three to the right
add_data(x, "range", n=c(2,3), range=0.1)
}
