% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanint_data.R
\name{meanint_data}
\alias{meanint_data}
\title{Integer Observations and Mean}
\usage{
meanint_data(x, r = range(x), ...)
}
\arguments{
\item{x}{numeric: number of observations or x values}

\item{r}{numeric: the range in which the x values allowed (default: \code{range(x)})}

\item{...}{further parameters given to \code{mean}}
}
\value{
A set of integer observations with an integer mean.
}
\description{
The \code{meanint_data} function generates a set of integer observations with a specified integer mean.
It takes the number of observations or \code{x} values  and an optional range parameter, \code{r}, that defines the permissible range
of x values (defaulting to the range of \code{x}). Additional parameters are passed to the \code{mean} function.
The function employs a iterative process, adjusting individual observations to achieve an integer mean.
It uses a random selection approach, modifying a randomly chosen observation and checking if the resulting mean is closer to an integer.
The process continues until the mean becomes an integer.
}
\examples{
x <- meanint_data(10, c(1, 10))
mean(x)
}
