% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result.R
\name{as_result}
\alias{as_result}
\alias{as_res}
\alias{tolerance}
\alias{tol}
\alias{rounded}
\alias{val}
\alias{digits}
\title{Results with Rounding}
\usage{
as_result(x, digits, tol = NA, FUN = round2)

tol(x)

rounded(x)

val(x)

digits(x)

as_res(x, digits, tol = NA, FUN = round2)

tolerance(x)
}
\arguments{
\item{x}{numeric: value to round}

\item{digits}{integer or character: Number of digits to use for rounding, see Details.}

\item{tol}{numeric: tolerance for the result (defaults to \code{2*10^(-digits)} if NA)}

\item{FUN}{function: rounding function (default: internal \code{round2()})}
}
\value{
A list of class \code{result} containing:
\item{x}{Original value}
\item{r}{Rounded value}
\item{digits}{Digits used for rounding}
\item{tol}{Tolerance for the result}
}
\description{
Rounds \code{x} according to \code{digits} and the rounding function \code{FUN}, and sets
a tolerance for the result. If \code{tol} is not provided, it defaults to \code{2*10^(-digits)}.
}
\details{
Results with Rounding

Creates a structured result with a numeric value rounded according to specified digits,
an optional tolerance, and a rounding function.

By default, rounding is performed using an \strong{internal function \code{round2()}}, which is similar
to \code{exams::round2()}, but users should not call it directly. You can also supply a
custom rounding function via the \code{FUN} argument.

If \code{digits} is a character, the following abbreviations are recognized:
\describe{
\item{\code{"integer"}}{digits = 0}
\item{\code{"\%"}}{digits = 2}
\item{\code{"probability"}}{digits = 4}
}
Partial matching of these names is allowed.
}
\examples{
x <- as_result(1/3, "probability")
tol(x)
rounded(x)
digits(x)
}
