% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperloop.R
\name{gapply}
\alias{gapply}
\alias{apply_grid}
\title{Apply Grid}
\usage{
gapply(FUN, ..., .simplify = TRUE)

apply_grid(FUN, ..., .simplify = TRUE)
}
\arguments{
\item{FUN}{function or character: a string naming the function to be called}

\item{...}{list: of arguments of the function to be called. The \code{names} attribute of \code{args} returns the argument \code{names}}

\item{.simplify}{logical: should the result be simplified to a data frame (if possible)? (default: \code{TRUE})}
}
\value{
A list or a data frame with the function results.
}
\description{
Runs all combinations of elements in \code{...} as parameters of \code{FUN} (grid apply).
\code{I(.)} can be used to avoid that an element is interpreted as a grid value.
If an error occurs, then the result of \code{FUN} will not be stored. You may notice missing indices
in the returning list.
}
\examples{
# 8 function calls: sum(1,3,5), sum(1,3,6), ..., sum(2,4,6)
gapply("sum", 1:2, 3:4, 5:6)
# 4 function calls: sum(1,3,5:6), sum(1,4,5:66), ..., sum(2,4,5:6)
gapply("sum", 1:2, 3:4, I(5:6))
}
