\name{exams2particify}
\alias{exams2particify}

\title{Generation of Exam/Quiz Sessions in Particify Format}

\description{
  Interface for generating comma-separated files for import
  in the audience response system Particify.
}

\usage{
exams2particify(file, n = 1L, dir = ".", name = "particify",
  quiet = TRUE, resolution = 100, width = 4, height = 4, svg = FALSE,
  abstention = FALSE, fix_choice = TRUE, \dots)
}

\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{dir}{character. The default is either display on the screen or
    the current working directory.}
  \item{name}{character. A name prefix for resulting exercises and RDS file.}
  \item{quiet}{logical. Should output be suppressed when calling
    \code{\link[exams]{xweave}} and \code{\link[tools]{texi2dvi}}.}
  \item{resolution, width, height}{numeric, passed to \code{\link[exams]{xweave}}.}
  \item{svg}{logical. Should graphics be rendered in SVG or PNG (default)?}
  \item{abstention}{logical. Are abstentions allowed for choice questions?}
  \item{fix_choice}{logical. Should math markup be removed in single and multiple
    choice lists? (This may be needed for older Particify versions where math
    markup is rendered in the question itself but not the choice list.)}
  \item{\dots}{arguments passed on to \code{\link[exams]{xexams}}.}
}

\details{
  \code{exams2particify} generates exams in comma-separated values (CSV)
  format that can be imported into the audience response system Particify
  (\url{https://particify.de/}) using \code{\link[exams]{xexams}}.
  In particular, single-choice and multiple-choice exercises are fully
  supported while num and string question are converted to open-ended text
  questions.

  The function proceeds by (1) calling \code{\link[exams]{xweave}}
  on each exercise, (2) reading the resulting Markdown/LaTeX text, (3) transforming
  the text to Markdown, and (4) embedding the Markdown text into the
  CSV format for Particify.
  For steps (1) and (2) the standard drivers in \code{xexams} are used.  
  For step (3) a suitable transformation function is set up on the fly
  using \code{\link[exams]{make_exercise_transform_pandoc}}.
  For step (4) a custom writer function is set up on the fly.
}

\value{
  A list of exams as generated by \code{\link[exams]{xexams}} is
  returned invisibly.
}

\examples{
## load package and enforce par(ask = FALSE)
library("exams")
options(device.ask.default = FALSE)

## output directory
dir.create(mydir <- tempfile())

## create a CSV file particify-1.csv for import in Particify
exams2particify(c("swisscapital.Rmd", "capitals.Rmd", "deriv2.Rmd",
  "boxplots.Rmd", "ttest.Rmd", "function.Rmd"), dir = mydir)
}

\keyword{utilities}
