% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address2index.R
\name{xl.index2address}
\alias{xl.address2index}
\alias{xl.index2address}
\title{Converts Excel address to indexes and vice versa.}
\usage{
xl.index2address(top, left, bottom = NULL, right = NULL)

xl.address2index(str.range)
}
\arguments{
\item{top}{integer top index of top-left cell}

\item{left}{integer left index of top-left cell}

\item{bottom}{integer bottom index of bottom-right cell}

\item{right}{integer right index of bottom-right cell}

\item{str.range}{character Excel range address}
}
\value{
xl.index2address returns character address (e. g. A1:B150), 
  xl.address2index returns vector with four components: top, left, bottom,
  right.
}
\description{
Converts Excel address to indexes and vice versa.
}
\examples{

xl.address2index("A1:D150")
xl.index2address(top=1, left=1)

\dontrun{
a1 \%=xl\% a1
a1 = iris
addr = xl.binding.address(a1)$address
xl.address2index(addr) 

}

}

