% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{readDataDict}
\alias{readDataDict}
\title{Read in the data dictionary}
\usage{
readDataDict(
  excelFile,
  dictionarySheet = "DataDictionary",
  range,
  colnames,
  origin
)
}
\arguments{
\item{excelFile}{Character, Path and Name of the data file}

\item{dictionarySheet}{Character, Name of the dictionary sheet within the file, defaults to 'DataDictionary'}

\item{range}{Optional, Range of Excel sheet to restrict import to (ie. range="A1:F6")}

\item{colnames}{Optional, Column names of the dictionary,
defaults to those used in the Excel template:
 c('VariableName', 'Description (optional)', 'Type', 'Minimum', 'Maximum', 'Levels')}

\item{origin}{Optional, the date origin of Excel dates, defaults to 30 December 1899}
}
\value{
A data frame with an entry for each variable to be imported
}
\description{
This function reads in a data dictionary from an Excel file, based on the
[DataDictionary.xlsm template](https://github.com/biostatsPMH/exceldata#readme)
}
\details{
It assumes that the columns names  have not been altered and are:
c('VariableName', 'Description (optional)', 'Type', 'Minimum', 'Maximum', 'Levels')

To override these column names specify colnames as an argument, ensuring
that the content of the columns is in the above order.
As of the time of writing, the origin date in Excel is 30 December 1899. To override this specify origin="yyy-mm-dd"

To read in only part of the excel sheet specify the desired range (ie range="A1:F6")
}
\examples{
\dontrun{
exampleDataFile <- system.file("extdata", "exampleData.xlsx", package = "exceldata")
dictionary <- readDataDict(exampleDataFile, dictionarySheet = 'DataDictionary')
}
}
