% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exif_read.R
\name{exif_call}
\alias{exif_call}
\alias{exif_version}
\title{Call ExifTool from R}
\usage{
exif_call(args = NULL, path = NULL, stdout = TRUE, quiet = FALSE, ...)

exif_version(quiet = TRUE)
}
\arguments{
\item{args}{Character vector of arguments, each written in same
form as you would if writing them on the command line
(e.g. \code{"-n"} or \code{"-csv"})}

\item{path}{A character vector giving one or more file paths.}

\item{stdout}{Where output to stdout should be sent. If
\code{TRUE} (the default), the output is captured in a
character vector. For other options, see the help file for
\code{\link[base]{system2}}, the function to which this
argument's value gets passed along.}

\item{quiet}{Use \code{FALSE} to display diagnostic
information. Default value is \code{FALSE}.}

\item{...}{Additional arguments to be passed to \code{system2()}.}
}
\value{
The standard output as a character vector.
}
\description{
Uses \code{system()} to run a basic call to \code{exiftool}.
}
\details{
For examples of the command-line calls to ExifTool (all
    of which can be reproduced by calls to \code{exif_call}), see
    \url{https://exiftool.org/examples.html}.
}
\examples{
\dontrun{
## Find local ExifTool version using exif_version() or exif_call()
exif_version()
exif_call(args = "-ver")

## Make temporary copies of a couple jpeg files
tmpdir <- tempdir()
src_files <- dir(system.file(package = "exiftoolr", "images"),
                 full.names = TRUE)
files <- file.path(tmpdir, basename(src_files))
file.copy(src_files, files)

## Both of the following extract the same tags:
exif_read(files, tags = c("filename", "imagesize"))
exif_call(args = c("-n", "-j", "-q", "-filename", "-imagesize"),
          path = files)

## Set value of a new "Artist" field in photo's metadata
file1 <- files[1]
exif_read(file1, tags = "artist")
exif_call(path = file1, args = "-Artist=me")
exif_read(file1, tags = "artist")

## Remove all but a few essential fields
length(exif_read(file1))
exif_call(path = file1, args = "-all=")
length(exif_read(file1))
exif_read(file1)

## Clean up
unlink(files)
}
}
