% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{check_ancova}
\alias{check_ancova}
\title{Result of ANCOVA model check}
\usage{
check_ancova(data, response_vbl, time_vbl, batch_vbl, alpha = 0.05)
}
\arguments{
\item{data}{A data frame with the columns specified by \code{response_vbl},
\code{time_vbl} and \code{batch_vbl}.}

\item{response_vbl}{A character string specifying the response variable name
that must be a column of \code{data}.}

\item{time_vbl}{A character string specifying the time variable name that
must be a column of \code{data}.}

\item{batch_vbl}{A character string specifying the column in \code{data}
with the grouping information (i.e. a factorial variable) for the
differentiation of the observations of the different batches.}

\item{alpha}{A numeric value specifying the significance level for the
decision which model is appropriate, i.e. if the assumption of
\emph{common slope} or \emph{common intercept} is appropriate or not.
The default is \code{0.05}.}
}
\value{
A numeric vector of the form \code{c(ci, cs)} is returned, specifying
if a common intercept is appropriate (\code{ci = 1}) or not (\code{ci = 0})
and if a common slope is appropriate (\code{cs = 1}) or not (\code{cs = 0}).
}
\description{
The function \code{check_ancova()} fits an ANalysis of COVAriance (ANCOVA)
model to figure out which kind of linear regression model suits the
(historical) data best.
}
\details{
The function \code{check_ancova()} fits an ANCOVA (ANalyis of
COVAriance) model to the data contained in the provided data frame. Based
on \code{alpha}, it checks if the intercepts and/or slopes between the
groups differ significantly or not.
}
\seealso{
\code{\link[stats]{aov}}.
}
\keyword{internal}
