% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{find_poi}
\alias{find_poi}
\title{Point of intersection}
\usage{
find_poi(
  srch_range,
  model,
  sl,
  alpha = 0.05,
  ivl = "confidence",
  ivl_type = "one.sided",
  ivl_side = "lower",
  ...
)
}
\arguments{
\item{srch_range}{A vector of length \code{2} specifying the end-points of
the (time) range within which the minimal distance is expected to be found.}

\item{model}{A linear model object of type \sQuote{\code{lm}}.}

\item{sl}{A numeric variable specifying the \dQuote{specification limit}
(SL). Another kind of acceptance criterion may be regarded as SL.}

\item{alpha}{A numeric value specifying the significance level of the
confidence or prediction interval that is calculated for the provided
linear model. The default value is \code{0.05}.}

\item{ivl}{A character string of either \code{"confidence"} or
\code{"prediction"}, i.e. specifying the type of interval of interest.
The default is \code{"confidence"}.}

\item{ivl_type}{A character string specifying if a \dQuote{one sided} or
a \dQuote{two sided} interval should be calculated, i.e. either
\code{"one.sided"} or \code{"two.sided"}, respectively. The default is
\code{"one.sided"}.}

\item{ivl_side}{A character string specifying if the \dQuote{upper} or the
\dQuote{lower} limit is the relevant limit, i.e. either \code{"upper"} or
\code{"lower"}, respectively. The default is \code{"lower"}.}

\item{...}{Additional named or unnamed arguments passed on to
\code{\link[stats]{uniroot}()}.}
}
\value{
A numeric value representing the value of \eqn{x} where the distance
between the two lines of interest is minimal is returned.
}
\description{
The function \code{find_poi()} determines the point where the distance
between two lines is minimal, e.g., the distance between a specification or
expiry limit and a confidence or prediction interval. The estimation is done
by aid of \code{\link[stats]{uniroot}()} from the \sQuote{\code{stats}}
package.
}
\details{
The function \code{find_poi()} (find the \dQuote{point of
intersection}) estimates the value of \eqn{x} (e.g., the time) where the
difference between the upper or lower confidence or prediction interval and
the upper or lower acceptance criterion (e.g., the specification or the
expiry limit) is minimal. Confidence or prediction intervals are calculated
for the \code{model} provided. The POI is determined by aid of the
\code{\link[stats]{uniroot}()} function from the \sQuote{\code{stats}}
package. The distance between the two lines of interest is calculated using
the function \code{\link{get_distance}()}, and it is this distance which
\code{uniroot()} tries to minimise. Recommendations on how to estimate shelf
life or expiry can be found in the corresponding section below.
}
\section{How to estimate shelf life or expiry}{

ICH Q1E recommends that \dQuote{\emph{For an attribute known to decrease with
time, the lower one-sided 95 percent confidence limit should be compared
to the acceptance criterion. For an attribute known to increase with time,
the upper one-sided 95 percent confidence limit should be compared to the
acceptance criterion. For an attribute that can either increase or decrease,
or whose direction of change is not known, two-sided 95 percent confidence
limits should be calculated and compared to the upper and lower acceptance
criteria.}} Since attributes often either decrease or increase, the default
for \code{ivl_type} is \code{one.sided}.

According to the ARGPM guidance \dQuote{Stability testing for prescription
medicines}, the shelf life or expiry limit is estimated as the point where
the upper or lower limit of the 95\% confidence interval of the linear model
fitted to the data intersects the worst case scenario limit. The worst case
scenario limit is obtained by adding/subtracting the absolute difference of
specification limit and release limit to/from the common intercept of the
test batches or the intercept of the worst performing batch.
}

\references{
Therapeutic Goods Administration (TGA) of the Department of Health of the
Australian Government, Australian Regulatory Guidelines for Prescription
Medicines (ARGPM), Stability testing for prescription medicines,
Version 1.1, March 2017

International Council for Harmonisation of Technical Requirements for
Registration of Pharmaceuticals for Human (ICH), Harmonised Tripartite
Guideline, Evaluation of Stability Data Q1E, step 4, February 2003
(CPMP/ICH/420/02).
}
\seealso{
\code{\link{get_distance}}, \code{\link[stats]{uniroot}},
\code{\link{expirest_osle}}, \code{\link{expirest_wisle}}.
}
\keyword{internal}
