% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_xformed_variables}
\alias{get_xformed_variables}
\title{Transformation of variables}
\usage{
get_xformed_variables(
  data,
  response_vbl,
  time_vbl,
  xform = c("no", "no"),
  shift = c(0, 0)
)
}
\arguments{
\item{data}{A data frame with the columns specified by \code{response_vbl},
\code{time_vbl} and \code{batch_vbl}.}

\item{response_vbl}{A character string that specifies the response variable
name that must be a column of \code{data}.}

\item{time_vbl}{A character string that specifies the time variable name
that must be a column of \code{data}.}

\item{xform}{A vector of two character strings that specifies the
transformation of the response and the time variable. The default is
\dQuote{no} transformation, i.e. \code{c("no", "no")}, where the first
element specifies the transformation of the \eqn{x} variable and the
second element the transformation of the \eqn{y} variable. Valid
alternatives for \eqn{x} and/or \eqn{y} variable transformation are
\code{"log"} (natural logarithm), \code{"sqrt"} (square root) and
\code{"sq"} (square).}

\item{shift}{A vector of two values which will be added to the variables
\eqn{x} and/or \eqn{y} before they are transformed as specified by the
\code{xform} parameter, where the first element will be added to the
\eqn{x} variable and the second element to the \eqn{y} variable. The
purpose is to prevent an undefined state which could arise when variables
with values of \eqn{\leq 0} are log or square root transformed. The
default is \code{c(0, 0)}.}
}
\value{
The provided data frame with (a) new column(s) of the transformed
variable(s).
}
\description{
The function \code{get_xformed_variables()} transforms the variables as
needed.
}
\details{
The function \code{get_xformed_variables()} transforms the variables
(\code{response_vbl} and/or \code{time_vbl}) as specified by the parameters
\code{xform} and \code{shift}.
}
\seealso{
\code{\link{expirest_osle}}, \code{\link{expirest_wisle}}.
}
\keyword{internal}
