% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain_tree}
\alias{explain_tree}
\title{Explain a target using a simple decision tree (classification or regression)}
\usage{
explain_tree(
  data,
  target,
  n,
  max_cat = 10,
  max_target_cat = 5,
  maxdepth = 3,
  minsplit = nrow(data)/10,
  cp = 0,
  size = 0.7,
  out = "plot",
  ...
)
}
\arguments{
\item{data}{A dataset}

\item{target}{Target variable}

\item{n}{weigths (for count data)}

\item{max_cat}{Drop categorical variables with higher number of levels}

\item{max_target_cat}{Maximum number of categories to be plotted for target (except NA)}

\item{maxdepth}{Maximal depth of the tree (rpart-parameter)}

\item{minsplit}{The minimum number of observations that must exist in a node to split.}

\item{cp}{Complexity parameter (rpart-parameter)}

\item{size}{Textsize of plot}

\item{out}{Output of function: "plot" | "model"}

\item{...}{Further arguments}
}
\value{
Plot or additional the model (if out = "model")
}
\description{
Explain a target using a simple decision tree (classification or regression)
}
\examples{
data <- iris
data$is_versicolor <- ifelse(iris$Species == "versicolor", 1, 0)
data$Species <- NULL
explain_tree(data, target = is_versicolor)
}
