% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powoGenera.R
\name{powoGenera}
\alias{powoGenera}
\title{Extract list of genera for any plant family}
\usage{
powoGenera(family,
           genus = NULL,
           hybrid = FALSE,
           country = NULL,
           verbose = TRUE,
           rerun = FALSE,
           save = FALSE,
           dir = "results_powoGenera",
           filename = "output")
}
\arguments{
\item{family}{Either one family name or a vector of multiple families that
is present in POWO.}

\item{genus}{Either one genus name or a vector of multiple genera
that is present in POWO. If any genus name is not provided, then the
function will search all accepted genera known for the target family.}

\item{hybrid}{Logical, if \code{TRUE}, the search results will include
hybrid genera.}

\item{country}{Either one country name or a vector of multiple countries.
If country names are provided, then the function will return only the genera
that are native to such countries, according to POWO.}

\item{verbose}{Logical, if \code{FALSE}, a message showing each step during
the POWO search will not be printed in the console in full.}

\item{rerun}{Logical, if \code{TRUE}, a previously stopped search will continue
from where it left off, starting with the last retrieved taxon. Please ensure
that the 'filename' argument exactly matches the name of the CSV file saved
from the previous search, and that the previously saved CSV file is located
within a subfolder named after the current date. If it is not, please rename
the date subfolder accordingly."}

\item{save}{Logical, if \code{TRUE}, the search results will be saved on disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_powoGenera} and the search results
will be saved within a subfolder named after the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}
}
\value{
A table with the following fields: family, genus, authors,
scientific_name, publication (information about the protologue of the genus),
species_number, native_to_country (original distribution according to
political country), native_to_botanical_countries (original distribution
according to botanical country), introduced_to_country (exotic distribution
according to political country), introduced_to_botanical_countries (exotic
distribution according to botanical country), kew_id (genus code within Kew's
databases), powo_uri (URI to access each genus in POWO).
}
\description{
Produces a CSV file listing all genera with associated number
of accepted species and geographical distribution for any vascular plant family
at \href{https://powo.science.kew.org/}{Plants of the World Online (POWO)}.
}
\examples{
\dontrun{
library(expowo)

powoGenera(family = "Lecythidaceae",
           verbose = TRUE,
           save = FALSE,
           dir = "results_powoGenera",
           filename = "Lecythidaceae_genera")

powoGenera(family = "Lecythidaceae",
           genus = "Bertholletia",
           country = c("Argentina", "Brazil", "French Guiana"),
           verbose = TRUE,
           save = FALSE,
           dir = "results_powoGenera",
           filename = "Lecythidaceae_search")
}

}
\seealso{
\code{\link{megaGen}}

\code{\link{topGen}}

\code{\link{powoSpecies}}

\code{\link{powoFam}}

\code{\link{POWOcodes}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
