% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.1-fs.R
\name{fs.}
\alias{fs.}
\title{Workhorse for fs Methods}
\usage{
fs.(object, top, uniqueFx, keep, ...)
}
\arguments{
\item{object}{An \code{ExprsArray} object to undergo feature selection.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. A numeric vector can also be used
to indicate specific features by location, similar to a character vector.}

\item{uniqueFx}{A function call unique to the method.}

\item{keep}{A numeric scalar. Specifies the number of top features that should get
returned by the feature selection method. Use of \code{keep} is generally not
recommended, but can speed up analyses of large data.}

\item{...}{Arguments passed to the detailed function.}
}
\value{
Returns an \code{ExprsArray} object.
}
\description{
Used as a back-end wrapper for creating new fs methods.
}
\details{
If the uniqueFx returns a character vector, it is assumed
 that the fs method is for feature selection only. If the
 uniqueFx returns a list, it is assumed that the fs method
 is a reduction model method only.
}
