% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_table.R
\name{htmlTable.etable}
\alias{htmlTable.etable}
\alias{knit_print.etable}
\title{Outputting HTML tables in RStudio viewer/R Notebooks}
\usage{
\method{htmlTable}{etable}(x, digits = getOption("expss.digits"), ...)

knit_print.etable(x, digits = getOption("expss.digits"), ...)
}
\arguments{
\item{x}{a data object (result of \link{fre}/\link{cro} and etc)}

\item{digits}{integer By default, all numeric columns are rounded to one digit after
decimal separator. Also you can set this argument by option 'expss.digits'
- for example, \code{option(expss.digits = 2)}. If it is NA than all
numeric columns remain unrounded.}

\item{...}{further parameters for \link[htmlTable]{htmlTable}.}
}
\value{
Returns a string of class htmlTable
}
\description{
This is method for rendering results of \link{fre}/\link{cro}/\link{tables} in
Shiny/RMarkdown and etc. For detailed description of function and its
arguments see \link[htmlTable]{htmlTable}. You may be interested in
\code{options(expss.output = "viewer")} for automatical rendering tables
in the RStudio viewer or  \code{options(expss.output = "rnotebook")} for
rendering in the R notebooks. See \link{expss.options}.
}
\examples{
\dontrun{ 
data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      cyl = "Number of cylinders",
                      disp = "Displacement (cu.in.)",
                      hp = "Gross horsepower",
                      drat = "Rear axle ratio",
                      wt = "Weight (1000 lbs)",
                      qsec = "1/4 mile time",
                      vs = "Engine",
                      vs = c("V-engine" = 0,
                             "Straight engine" = 1),
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      carb = "Number of carburetors"
)

options(expss.output = "viewer")
mtcars \%>\% 
     tab_cols(total(), am \%nest\% vs) \%>\% 
     tab_cells(mpg, hp) \%>\% 
     tab_stat_mean() \%>\% 
     tab_cells(cyl) \%>\% 
     tab_stat_cpct() \%>\% 
     tab_pivot()
     
options(expss.output = NA)   
 
}
}
