% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.etable}
\alias{merge.etable}
\alias{\%merge\%}
\title{Merge two tables/data.frames}
\usage{
x \%merge\% y
}
\arguments{
\item{x}{data.frame or results of \code{fre}/\code{cro_*}/\code{table_*}}

\item{y}{data.frame or results of \code{fre}/\code{cro_*}/\code{table_*}}
}
\value{
data.frame
}
\description{
\code{\%merge\%} is infix shortcut for base \link[base]{merge} with 
\code{all.x = TRUE} and  \code{all.y = FALSE} (left join). There is also 
special method for combining results of \code{cro_*} and \code{fre}. For them
\code{all = TRUE} (full join). It allows make complex tables from simple
ones. See examples. Strange result is possible if one or two arguments have
duplicates in first column (column with labels).
}
\examples{
data(mtcars)
# apply labels
mtcars = apply_labels(mtcars,
                mpg = "Miles/(US) gallon",
                cyl = "Number of cylinders",
                disp = "Displacement (cu.in.)",
                hp = "Gross horsepower",
                drat = "Rear axle ratio",
                wt = "Weight (lb/1000)",
                qsec = "1/4 mile time",
                vs = "V/S",
                vs = c("V-engine" = 0, "Straight engine" = 1),
                am = "Transmission (0 = automatic, 1 = manual)",
                am = c(automatic = 0, manual = 1),
                gear = "Number of forward gears",
                carb = "Number of carburetors"
)

# table by 'am'
tab1 = calculate(mtcars, cro_cpct(gear, am))
# table with percents
tab2 = calculate(mtcars, cro_cpct(gear, vs))

# combine tables
tab1 \%merge\% tab2

# complex tables
# table with counts
counts = calculate(mtcars, cro(list(vs, am, gear, carb), list("Count")))
# table with percents
percents = calculate(mtcars, cro_cpct(list(vs, am, gear, carb), list("Column, \%")))

# combine tables
counts \%merge\% percents
}
\seealso{
\link{fre}, \link{cro}, \link{cro}, \link{cro_fun}, \link[base]{merge}
}
