% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expCombine.R
\name{expCombine}
\alias{expCombine}
\title{Combine two experiments with different outputs}
\usage{
expCombine(e1, e2, name = NULL)
}
\arguments{
\item{e1}{First experiment to combine.}

\item{e2}{An second experiment to combine, must share the same
config as e1.}

\item{name}{Optional name for the resulting experiment. If not specified
the new experiment will be called "e1_name U e2_name"}
}
\value{
An new experiment with common rows and all columns.
}
\description{
This fuctions joints two experiments sharing the same configuration
of methods, problems and parameters but different outputs. The resulting
experiment includes the common rows for both experiments with all the
output columns.
}
\examples{
# In this example we turn the wekaExperiment into two different experiments,
# with different outputs to combine them:

df_acc  <- wekaExperiment[,
           c("method", "problem", "fold", "featureSelection", "accuracy")]
df_time <- wekaExperiment[,
           c("method", "problem", "fold", "featureSelection", "trainingTime")]

exp_acc <- expCreate(df_acc, name="acc", parameter="fold")
exp_time <- expCreate(df_time, name="time", parameter="fold")

# With expCombine we can mix the two experiments:
expCombine(exp_acc, exp_time)
}

