% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expExtend.R
\name{expExtend}
\alias{expExtend}
\title{Extend an experiment by adding new parameters}
\usage{
expExtend(e, parameters)
}
\arguments{
\item{e}{Input experiment}

\item{parameters}{A list of strings containing the values of the new
parameters, the name for each one of them will be given by the name of the
corresponding object in the list.}
}
\value{
A modified exreport experiment object with additional parameters.
}
\description{
This function extends an existing exreport experiment object by adding new
parameters with fixed values.
}
\examples{
# We load the wekaExperiment problem as an experiment and then add a new param
# with a default value.

experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
expExtend(experiment, list(discretization = "no"))
}

