% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areal_calc.R
\name{areal_calc}
\alias{areal_calc}
\title{Areal data calculation}
\usage{
areal_calc(polygon_layer, higher_geo_lay, unique_id_code, crs)
}
\arguments{
\item{polygon_layer}{multipolygon object of class \code{sf}, \code{sfc} or \code{sfg}.}

\item{higher_geo_lay}{multipolygon object of class \code{sf}, \code{sfc} or \code{sfg}.}

\item{unique_id_code}{a string; indicating a unique ID column of \code{higher_geo_lay},
used as the summary areas.}

\item{crs}{coordinate reference system: integer with the EPSG code, or character based on proj4string.}
}
\value{
a \code{tibble} data frame object containing four columns is returned:
\itemize{
\item the \code{unique_id_code} of \code{higher_geo_lay}
\item the total area of each polygon
in \code{higher_geo_lay} (TotalArea),
\item the total area covered by \code{polygon_layer} features (AreaCovered),
\item the ratio between the total area covered by \code{polygon_layer} and total area of
\code{higher_geo_lay} polygon (Ratio).
}
}
\description{
Computes three different summary statistics:
(1) \code{TotalArea} total area of each polygon;
(2) \code{AreaCovered} area covered by a multipolygon object within a high order polygon; and,
(3) \code{Ratio} ratio between \code{AreaCovered} and \code{TotalArea} i.e.
ratio between an area covered by a given set of features and total area of a higher-order geography polygon.
}
\details{
The function requires two sets of polygon data: high-order and low-order geographic polygons
}
\examples{
# Run areal_calc() using the packages' dummy data sets.
# The data sets are georeferenced on wgs84. However, a planar system is used to measure areas.
# For the examples provided here, points and polygons relate to the United Kingdom.
# So the British National Grid is used.
outcome <- areal_calc(
 polygon_layer = pol_small,
 higher_geo_lay = pol_large,
 unique_id_code = "large_pol_",
 crs = "epsg:27700")

 # print the outcome
 outcome


}
