% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grp_routine.R
\name{grp_routine}
\alias{grp_routine}
\alias{grp_routine_}
\title{Mutate a character/factor based on conditions.}
\usage{
grp_routine(data, col, ..., ret_factor = FALSE)

grp_routine_(data, col, ..., .dots, ret_factor = FALSE)
}
\arguments{
\item{data}{A \code{\link[base]{data.frame}} or \code{\link[dplyr]{tbl}}.}

\item{col}{Name of the generated column. Use a bare name when using NSE
functions and a character (quoted) name when using SE functions (functions
that end with underscores).}

\item{...}{Specification of group assignment. Use named conditions, like
\code{top2 = x > 5}.}

\item{ret_factor}{Whether to convert the column into factor.}

\item{.dots}{Used in conjunction with \code{...} to support both explicit
and implicit arguments.}
}
\description{
\code{grp_routine} functions like a serious of nested \code{ifelse} where
a series of conditions are evaluated and different values are assigned based
on those conditions.
}
\section{Functions}{
\itemize{
\item \code{grp_routine_}: SE version of grp_routine.
}}

\examples{
df <- data.frame(v1 = letters[1:5], v2 = 1:5)
df

# By default, it creates new groups
grp_routine(df, "group",
               first = v1 \%in\% c("a", "b"),
               second = v2 == 3,
               third = v2 >= 4)

# Gives a warning when the groups are not collectively exhaustive
grp_routine(df, "group",
               first = v1 \%in\% c("a", "b"),
               second = v2 == 3,
               third = v2 > 4)


# SE version
grp_routine_(df, "group",
               "first" = ~ v1 \%in\% c("a", "b"),
               "second" = ~ v2 == 3,
               .dots = setNames(list(~ v2 > 4), "third"))
}
