% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate-poisson-distribution.R
\name{BivPoiss}
\alias{BivPoiss}
\alias{dbvpois}
\alias{rbvpois}
\title{Bivariate Poisson distribution}
\usage{
dbvpois(x, y = NULL, a, b, c, log = FALSE)

rbvpois(n, a, b, c)
}
\arguments{
\item{x, y}{vectors of quantiles; alternativelly x may be a two-column
matrix (or data.frame) and y may be omitted.}

\item{a, b, c}{positive valued parameters.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation for the bivariate Poisson distribution.
}
\details{
Probability mass function
\deqn{
f(x) = \exp \{-(a+b+c)\} \frac{a^x}{x!} \frac{b^y}{y!} \sum_{k=0}^{\min(x,y)}
{x \choose k} {y \choose k} k! \left( \frac{c}{ab} \right)^k
}{
f(x) = exp(-(a+b+c)) * (a^x)/x! * (b^y)/y! *
sum(choose(x,k)*choose(y,k)*k!*(c/(a*b))^k)
}
}
\examples{

x <- rbvpois(5000, 7, 8, 5)
image(prop.table(table(x[,1], x[,2])))
colMeans(x)

}
\references{
Karlis, D. and Ntzoufras, I. (2003). Analysis of sports data by using bivariate Poisson models.
Journal of the Royal Statistical Society: Series D (The Statistician), 52(3), 381-393.

Kocherlakota, S. and Kocherlakota, K. (1992) Bivariate Discrete Distributions.
New York: Dekker.

Johnson, N., Kotz, S. and Balakrishnan, N. (1997). Discrete Multivariate Distributions.
New York: Wiley.

Holgate, P. (1964). Estimation for the bivariate Poisson distribution.
Biometrika, 51(1-2), 241-287.

Kawamura, K. (1984). Direct calculation of maximum likelihood estimator for the bivariate
Poisson distribution. Kodai mathematical journal, 7(2), 211-221.
}
\seealso{
\code{\link[stats]{Poisson}}
}
\concept{
Multivariate

Discrete
}
\keyword{distribution}
