% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half-t-distribution.R
\name{HalfT}
\alias{HalfT}
\alias{dht}
\alias{pht}
\alias{qht}
\alias{rht}
\title{Half-t distribution}
\usage{
dht(x, nu, sigma = 1, log = FALSE)

pht(q, nu, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qht(p, nu, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rht(n, nu, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{nu, sigma}{positive valued degrees of freedom and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the half-t distribution.
}
\details{
If \eqn{X} follows t distribution parametrized by degrees of freedom \eqn{\nu}
and scale \eqn{\sigma}, then \eqn{|X|} follows half-t distribution parametrized
by degrees of freedom \eqn{\nu} and scale \eqn{\sigma}.
}
\examples{

x <- rht(1e5, 2, 2)
hist(x, 500, freq = FALSE, xlim = c(0, 100))
curve(dht(x, 2, 2), 0, 100, col = "red", add = TRUE)
hist(pht(x, 2, 2))
plot(ecdf(x), xlim = c(0, 100))
curve(pht(x, 2, 2), 0, 100, col = "red", lwd = 2, add = TRUE)

}
\references{
Gelman, A. (2006). Prior distributions for variance parameters in hierarchical
models (comment on article by Browne and Draper).
Bayesian analysis, 1(3), 515-534.

Jacob, E. and Jayakumar, K. (2012).
On Half-Cauchy Distribution and Process.
International Journal of Statistika and Mathematika, 3(2), 77-81.
}
\seealso{
\code{\link{HalfNormal}}, \code{\link{HalfCauchy}}
}
\concept{
Univariate

Continuous
}
\keyword{distribution}
