/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class ShuffledIterator<E>
implements Iterator<E> {
    ArrayList<E> data;
    int nextIndex = 0;
    Random random;

    public ShuffledIterator(Collection<E> collection) {
        this.data = new ArrayList<E>(collection);
        this.random = new Random();
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.data.size();
    }

    @Override
    public E next() {
        if (this.nextIndex >= this.data.size()) {
            throw new NoSuchElementException();
        }
        int n = this.random.nextInt(this.data.size() - this.nextIndex);
        E e = this.data.get(this.nextIndex + n);
        this.data.set(this.nextIndex + n, this.data.get(this.nextIndex));
        this.data.set(this.nextIndex, e);
        ++this.nextIndex;
        return e;
    }

    @Override
    public void remove() {
        throw new RuntimeException("unimplemented");
    }

    public void reset() {
        this.nextIndex = 0;
    }
}

