/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.Set;
import org.extratrees.data.Row;

public abstract class AbstractBinaryTree<T extends AbstractBinaryTree<T, D>, D> {
    public T left;
    public T right;
    public int nSuccessors;
    public int column = -1;
    public double threshold;
    public D value;
    Set<Integer> tasks;

    public abstract D getNA();

    public D getValue() {
        return this.value;
    }

    public T getLeaf(Row row) {
        if (this.left == null) {
            return this.getItself();
        }
        if (Double.isNaN(row.get(this.column))) {
            return null;
        }
        if (row.get(this.column) < this.threshold) {
            return ((AbstractBinaryTree)this.left).getLeaf(row);
        }
        return ((AbstractBinaryTree)this.right).getLeaf(row);
    }

    public D getValue(Row row) {
        return this.valueFromLeaf(this.getLeaf(row));
    }

    public T getLeafMT(Row row, int n) {
        if (this.left == null) {
            return this.getItself();
        }
        if (this.column < 0) {
            if (((AbstractBinaryTree)this.left).tasks.contains(n)) {
                return ((AbstractBinaryTree)this.left).getLeafMT(row, n);
            }
            return ((AbstractBinaryTree)this.right).getLeafMT(row, n);
        }
        if (Double.isNaN(row.get(this.column))) {
            return null;
        }
        if (row.get(this.column) < this.threshold) {
            return ((AbstractBinaryTree)this.left).getLeafMT(row, n);
        }
        return ((AbstractBinaryTree)this.right).getLeafMT(row, n);
    }

    public D getValueMT(Row row, int n) {
        return this.valueFromLeaf(this.getLeafMT(row, n));
    }

    public T getLeaf(double[] dArray, int n) {
        if (this.nSuccessors <= n || this.left == null) {
            return this.getItself();
        }
        if (Double.isNaN(dArray[this.column])) {
            return null;
        }
        if (dArray[this.column] < this.threshold) {
            return ((AbstractBinaryTree)this.left).getLeaf(dArray, n);
        }
        return ((AbstractBinaryTree)this.right).getLeaf(dArray, n);
    }

    public D getValue(double[] dArray, int n) {
        return this.valueFromLeaf(this.getLeaf(dArray, n));
    }

    private D valueFromLeaf(T t) {
        if (t == null) {
            return this.getNA();
        }
        return ((AbstractBinaryTree)t).getValue();
    }

    public T getItself() {
        return (T)this;
    }
}

