% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-indices.R
\name{chk_indices}
\alias{chk_indices}
\alias{vld_indices}
\title{Check Indices}
\usage{
chk_indices(x, x_name = NULL)

vld_indices(x)
}
\arguments{
\item{x}{An object.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if an object is a list of indices ie vectors of one or more positive integer values.
}
\section{Functions}{
\itemize{
\item \code{vld_indices()}: Validate Indices

}}
\examples{
x <- list(c(2L, 1L))
chk_indices(x)
y <- c(2L, 1L)
try(chk_indices(y))
vld_indices(c(3L, 1L))
vld_indices(list(c(3L, 1L)))
}
