% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difftime.R
\name{step_difftime}
\alias{step_difftime}
\alias{tidy.step_difftime}
\title{difftimearithmic Transformation}
\usage{
step_difftime(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  time = NULL,
  tz = NULL,
  unit = "auto",
  columns = NULL,
  skip = FALSE,
  id = rand_id("difftime")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.  For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{time}{date-time or date objects. Used for reference. Must match the
type of variable.}

\item{tz}{an optional time zone specification to be used for the conversion,
mainly for "POSIXlt" objects.}

\item{unit}{character string. Units in which the results are desired. Must be
one of "auto", "secs", "mins", "hours","days",  and "weeks" Defaults to
"auto".}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
columns that will be affected) and \code{base}.
}
\description{
\code{step_difftime()} creates a \emph{specification} of a recipe step that will
calculate difftimes of the data.
}
\examples{
library(recipes)
example_date <- data.frame(
  dates = seq(as.Date("2010/1/1"), as.Date("2016/1/1"), by = "quarter")
 )

 example_datetime <- data.frame(
  datetimes = seq(ISOdate(1993,1,1), ISOdate(1993,1,2), by = "hour")
 )

rec <- recipe(~ dates, data = example_date) \%>\%
  step_difftime(dates, time = as.Date("2010/1/1"))

difftime_obj <- prep(rec)

bake(difftime_obj, new_data = NULL)

recipe(~ dates, data = example_date) \%>\%
  step_difftime(dates, time = as.Date("2010/1/1"), unit = "weeks") \%>\%
  prep() \%>\%
  bake(new_data = NULL)

recipe(~ datetimes, data = example_datetime) \%>\%
  step_difftime(datetimes, time = ISOdate(1993,1,1), unit = "secs") \%>\%
  prep() \%>\%
  bake(new_data = NULL)
}
