% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.radf}
\title{Summarizing radf models}
\usage{
\method{summary}{radf}(object, cv = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link[=radf]{radf()}}.}

\item{cv}{An object of class "cv". The output of \code{\link[=mc_cv]{mc_cv()}},
\code{\link[=wb_cv]{wb_cv()}} or \code{\link[=sb_cv]{sb_cv()}}}

\item{...}{further arguments passed to methods, not used.}
}
\value{
Returns a list of summary statistics,
the t-statistic and the critical values of the ADF, SADF and GSADF.
}
\description{
\code{summary} method for class "radf"
}
\examples{

# Simulate bubble processes, compute the t-stat and critical values
set.seed(4441)
dta <- data.frame(psy1 = sim_psy1(n = 100), psy2 = sim_psy2(n = 100))
rfd <- radf(dta)

# Summary, diagnostics and datestamp (default)
summary(rfd)
diagnostics(rfd)
datestamp(rfd)

#' # Diagnostics for 'sadf'
diagnostics(rfd, option = "sadf")

# Use log(T)/T rule of thumb to omit periods of explosiveness which are short-lived
rot <- round(log(NROW(rfd)) / NROW(rfd))
datestamp(rfd, min_duration = rot)
\dontrun{
# Summary, diagnostics and datestamp (Wild Bootstrapped critical values)

wb <- wb_cv(dta)

summary(rfd, cv = wb)
diagnostics(rfd, cv = wb)
datestamp(rfd, cv = wb)
}
}
