% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers-radf.R
\name{tidy.radf_obj}
\alias{tidy.radf_obj}
\alias{augment.radf_obj}
\title{Tidy a \code{radf_obj} object}
\usage{
\method{tidy}{radf_obj}(x, format = c("wide", "long"), panel = FALSE, ...)

\method{augment}{radf_obj}(x, format = c("wide", "long"), panel = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{radf_obj}.}

\item{format}{Long or wide format (default = "wide").}

\item{panel}{If TRUE then returns the panel statistics}

\item{...}{Further arguments passed to methods. Not used.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}
}
\description{
Summarizes information about \code{radf_obj} object.
}
\examples{
\donttest{
dta <- data.frame(psy1 = sim_psy1(n = 100), psy2 = sim_psy2(n = 100))

rfd <- radf(dta)

# Get the test statistic
tidy(rfd)

# Get the test statisticsequences
augment(rfd)

# Get the panel test statistic
tidy(rfd, panel = TRUE)
}
}
