% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf_wb.R
\name{radf_wb_cv2}
\alias{radf_wb_cv2}
\alias{radf_wb_distr2}
\title{Wild Bootstrap Critical Values}
\usage{
radf_wb_cv2(
  data,
  minw = NULL,
  nboot = 500L,
  adflag = 0,
  type = c("fixed", "aic", "bic"),
  tb = NULL,
  seed = NULL
)

radf_wb_distr2(
  data,
  minw = NULL,
  nboot = 500L,
  adflag = 0,
  type = c("fixed", "aic", "bic"),
  tb = NULL,
  seed = NULL
)
}
\arguments{
\item{data}{A univariate or multivariate numeric time series object, a numeric
vector or matrix, or a data.frame. The object should not have any NA values.}

\item{minw}{A positive integer. The minimum window size (default =
\eqn{(0.01 + 1.8/\sqrt(T))T}{(0.01 + 1.8 / \sqrtT)T}, where T denotes the sample size).}

\item{nboot}{A positive integer. Number of bootstraps (default = 500L).}

\item{adflag}{A positive integer. Number of lags when type is "fixed" or number
of max lags when type is either "aic" or "bic".}

\item{type}{Character. "fixed" for fixed lag, "aic" or "bic" for automatic lag
selection according to the criterion.}

\item{tb}{A positive integer. The simulated sample size.}

\item{seed}{An object specifying if and how the random number generator (rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is saved as "seed" attribute
of the returned value. The default, NULL, will not change rng state, and
return .Random.seed as the "seed" attribute. Results are different between
the parallel and non-parallel option, even if they have the same seed.}
}
\value{
For \code{radf_wb_cv2} a list that contains the critical values for the ADF,
BADF, BSADF and GSADF tests. For \code{radf_wb_distr} a list that
contains the ADF, SADF and GSADF distributions.
}
\description{
\code{radf_wb_cv} performs the Phillips & Shi (2020) wild bootstrap re-sampling
scheme, which is asymptotically robust to non-stationary volatility, to
generate critical values for the recursive unit root tests. \code{radf_wb_distr2}
computes the distribution.
}
\examples{
\donttest{
# Default minimum window
wb <- radf_wb_cv2(sim_data)

tidy(wb)

# Change the minimum window and the number of bootstraps
wb2 <- radf_wb_cv2(sim_data, nboot = 600, minw = 20)

tidy(wb2)

# Simulate distribution
wdist <- radf_wb_distr(sim_data)

autoplot(wdist)
}
}
\references{
Phillips, P. C., & Shi, S. (2020). Real time monitoring of
asset markets: Bubbles and crises. In Handbook of Statistics (Vol. 42, pp. 61-80). Elsevier.

Phillips, P. C. B., Shi, S., & Yu, J. (2015). Testing for
Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the
S&P 500. International Economic Review, 56(4), 1043-1078.
}
\seealso{
\code{\link{radf_mc_cv}} for Monte Carlo critical values and
\code{\link{radf_sb_cv}} for sieve bootstrap critical values.
}
