% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_extract.R
\name{get_xmatrix}
\alias{get_xmatrix}
\title{Get extraction matrix.}
\usage{
get_xmatrix(
  wio,
  exporter,
  perim = "country",
  partner = "WLD",
  sector = "TOTAL",
  inverse = TRUE
)
}
\arguments{
\item{wio}{A class \code{wio} object}

\item{exporter}{String, code of country or country group}

\item{perim}{String: \code{"country"} for country perspective and
\code{"WLD"} for world perspective.}

\item{partner}{String: code of country or country group
for bilateral perspectives (only with country).}

\item{sector}{Character string: code of sector or sector group
for sector perspectives (only with country).}

\item{inverse}{Boolean, if \code{TRUE} returns the global inverse extraction
matrix \code{Bnots}, if \code{FALSE} just the global extraction matrix \code{Anots}.}
}
\value{
The global (inverse) extraction matrix of the specified exporter.
}
\description{
Creates a global extraction matrix \code{Anots} of an exporter and its inverse
\code{Bnots}.
}
