% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_blinks.R
\name{extract_blinks}
\alias{extract_blinks}
\alias{extract_blinks.data.frame}
\alias{extract_blinks.eyelinkRecording}
\title{Extract blinks}
\usage{
extract_blinks(object)

\method{extract_blinks}{data.frame}(object)

\method{extract_blinks}{eyelinkRecording}(object)
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with events,
i.e., \code{events} slot of the \code{\link{eyelinkRecording}} object.}
}
\value{
Object of the same time as input, i.e., either a \code{\link{eyelinkRecording}} object
with an additional \code{blinks} slot or a data.frame with blinks' information. See
\code{\link{eyelinkRecording}} for details.
}
\description{
Extracts blinks from the \code{events} table of the \code{\link{eyelinkRecording}} object.. Normally,
you don't need to call this function yourself,
as it is called during the \code{\link{read_edf}} with default settings
(\emph{e.g.}, \code{import_blinks = TRUE}).
}
\examples{
data(gaze)

# by passing the recording
gaze <- extract_blinks(gaze)

# by passing events table
blinks <- extract_blinks(gaze$events)
}
\seealso{
read_edf, eyelinkRecording
}
