% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-epoch.R
\name{process_epoch_and_baselines}
\alias{process_epoch_and_baselines}
\title{Epoch and baseline processor}
\usage{
process_epoch_and_baselines(eyeris, timestamps, evs, lims, hz, verbose)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}}

\item{timestamps}{A list containing start and end timestamps}

\item{evs}{Events specification for epoching (character vector or list)}

\item{lims}{Time limits for epochs (numeric vector)}

\item{hz}{Sampling rate in Hz}

\item{verbose}{A flag to indicate whether to print detailed logging messages}
}
\value{
A list containing epoch and baseline results
}
\description{
This function processes a single block of pupil data to extract epochs and
optionally compute and apply baseline corrections. It handles the core
epoching and baselining logic for a single block of data.
}
\details{
This function is called by the internal \code{\link[=epoch_and_baseline_block]{epoch_and_baseline_block()}}
function.
}
\keyword{internal}
