% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-bidsify.R
\name{run_bidsify}
\alias{run_bidsify}
\title{Internal function to run bidsify on a single eye}
\usage{
run_bidsify(
  eyeris,
  save_all = TRUE,
  epochs_list = NULL,
  merge_epochs = FALSE,
  bids_dir = NULL,
  participant_id = NULL,
  session_num = NULL,
  task_name = NULL,
  run_num = NULL,
  merge_runs = FALSE,
  save_raw = TRUE,
  html_report = TRUE,
  report_seed = 0,
  report_epoch_grouping_var_col = "matched_event",
  eye_suffix = NULL,
  verbose = TRUE,
  raw_binocular_object = NULL
)
}
\arguments{
\item{eyeris}{An eyeris object}

\item{save_all}{Whether to save all data}

\item{epochs_list}{A list of epochs to include}

\item{merge_epochs}{Whether to merge epochs}

\item{bids_dir}{The directory to save the bids data}

\item{participant_id}{The participant id}

\item{session_num}{The session number}

\item{task_name}{The task name}

\item{run_num}{The run number}

\item{merge_runs}{Whether to merge runs}

\item{save_raw}{Whether to save raw data}

\item{html_report}{Whether to generate an html report}

\item{report_seed}{The seed for the report}

\item{report_epoch_grouping_var_col}{The column to use for grouping epochs in the report}

\item{eye_suffix}{The suffix to add to the eye data}

\item{verbose}{Whether to print verbose output}

\item{raw_binocular_object}{The raw binocular object}
}
\value{
A eyeris object
}
\description{
Internal function to run bidsify on a single eye
}
\keyword{internal}
