% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_sequence_data.R
\name{make_time_sequence_data}
\alias{make_time_sequence_data}
\title{make_time_sequence_data()}
\usage{
make_time_sequence_data(data, time_bin_size, aois = NULL,
  predictor_columns = NULL, other_dv_columns = NULL, summarize_by = NULL)
}
\arguments{
\item{data}{The output of \code{make_eyetrackingr_data}}

\item{time_bin_size}{How large should each time bin be? Units are whatever units your \code{time} column is in}

\item{aois}{Which AOI(s) is/are of interest? Defaults to all specified in
\code{make_eyetracking_r_data}}

\item{predictor_columns}{Which columns indicate predictor variables, and therefore should be
preserved in grouping operations?}

\item{other_dv_columns}{Within each time-bin, this function will calculate not only proportion-
looking, but also the mean of any columns specified here.}

\item{summarize_by}{Should the data be summarized along, e.g., participants, items, etc.? If
so, give column name(s) here. If left blank, will leave trials distinct. The former is needed
for more traditional analyses (\code{t.test}, \code{ANOVA}), while the latter is preferable for
mixed-effects models (\code{lmer})}
}
\value{
Data binned into time-bins, with proportion-looking and transformations as well as orthogonal
  time-polynomials for growth curve analysis
}
\description{
Creates time-bins and summarizes proportion-looking within each time-bin.
}
\details{
Aside from proportion looking (\code{Prop}), this function returns several columns useful for subsequent
analysis:

\itemize{
 \item \code{LogitAdjusted} - The logit is defined as \code{log( Prop / (1 - Prop) )}. This
 transformation attempts to map bounded \code{0,1} data to the real number line. Unfortunately,
 for data that is exactly 0 or 1, this is undefined. One solution is add a very small value to
 any datapoints that equal 0, and subtract a small value to any datapoints that equal 1 (we use
 1/2 the smallest nonzero value for this adjustment).
 \item \code{Elog} - Another way of calculating a corrected logit transformation is to
add a small value \code{epsilon} to both the numerator and denominator of the logit equation (we
use 0.5).
 \item \code{Weights} - These attempt to further correct the Elog transformation, since the
 variance of the logit depends on the mean. They can be used in a mixed effects model by setting
 the \code{weights=Weights} in \code{lmer} (note that this is the reciprocal of the
weights calculated in \href{http://talklab.psy.gla.ac.uk/tvw/elogit-wt.html}{this empirical logit
walkthrough}, so you do *not* set \code{weights = 1/Weights} as done there.) 
 \item \code{ArcSin} - The arcsine-root transformation of the raw proportions, defined as
\code{asin(sqrt(Prop))}
 \item \code{ot} - These columns (ot1-ot7) represent (centered) orthogonal time polynomials,
 needed for growth curve analysis. See
 \href{http://www.eyetracking-r.com/vignettes/growth_curve_analysis}{the vignette on growth curve
 models} for more details.
}
}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)

# bin data in 250ms bins, and generate a dataframe
# with a single AOI (Animate) predicted by Sex, and summarized by ParticipantName
response_time <- make_time_sequence_data(data,
                                         time_bin_size = 250,
                                         predictor_columns = c("Sex"),
                                         aois = "Animate",
                                         summarize_by = "ParticipantName"
)

# optionally specify other columns in the data
# to be included in the generated dataframe
# (e.g., for use in statistical models)
# bin data in 250ms bins, and generate a dataframe
# with Animate and MCDI_Total summarized by ParticipantName
response_time <- make_time_sequence_data(data,
                                         time_bin_size = 250,
                                         predictor_columns = c("Sex","MCDI_Total"),
                                         aois = "Animate", 
                                         summarize_by = "ParticipantName"
)

}

