% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_plot.R
\name{line_plot}
\alias{line_plot}
\title{line_plot}
\usage{
line_plot(
  data,
  x,
  y = "1",
  group = NULL,
  facet_x = NULL,
  facet_y = NULL,
  yoy = FALSE,
  size_line = 1,
  size = 11,
  palette = ez_col,
  labels_y = ez_labels,
  use_theme = theme_ez,
  facet_scales = "fixed"
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{group}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{facet_y}{A character. Evaluates to a column.}

\item{yoy}{Logical used to indicate whether a YOY grouping should be created.
Default is \code{FALSE}.}

\item{size_line}{width of line for \code{geom_line()}. Default is 1.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{palette}{Colour function.}

\item{labels_y}{label formatting function}

\item{use_theme}{ggplot theme function}

\item{facet_scales}{Option passed to scales argument in \code{facet_wrap} or
\code{facet_grid}. Default is \code{"fixed"}.}
}
\value{
A ggplot object.
}
\description{
Creates line plots.
}
\examples{
library(tsibbledata)
line_plot(pelt, "Year", "Hare")
line_plot(pelt, "Year", c("Hare", "Lynx"))
line_plot(pelt, "Year", "Hare", use_theme = ggplot2::theme_bw)
line_plot(pelt, "Year", c("Hare Population" = "Hare"))
}
