% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_run_cov.R
\name{long_run_covariance}
\alias{long_run_covariance}
\title{Estimate Long-run Covariance Kernel}
\usage{
long_run_covariance(
  X,
  h = 2 * ncol(X)^(1/5),
  K = bartlett_kernel,
  changes = NULL
)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{h}{The window parameter parameter for the estimation of the long run
covariance kernel. The default value is \code{h=2*ncol(X)^(1/5)}.
Note there exists an internal check such that \eqn{h=min(h,ncol(X)-1)} when
alternative options are given.}

\item{K}{Function indicating the kernel to use if \eqn{h>0}.}

\item{changes}{Vector of numeric change point locations. Can be NULL.}
}
\value{
Symmetric data.frame of numerics with dim of ncol(data) x ncol(data).
}
\description{
Estimate the long-run covariance kernel for functional data. That is, solve
\eqn{
   C_{\epsilon}(t,t') = \sum_{l=-\inf}^{\inf} \text{Cov}(\epsilon_0(t),
    \epsilon_l(t'))
 }
with sequence \eqn{(\epsilon_i : i \in \mathbb{Z})} defined as the centered
data (can center based on changes if given).
}
\examples{
result <- long_run_covariance(electricity,2)
}
