% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fable_ata.R
\name{forecast.ATA}
\alias{forecast.ATA}
\title{Forecast a model from the fable ATA model}
\usage{
\method{forecast}{ATA}(
  object,
  new_data,
  h = NULL,
  ci_level = 95,
  negative_forecast = TRUE,
  ...
)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{new_data}{A `tsibble` containing future information used to forecast.}

\item{h}{The forecast horison (can be used instead of `new_data` for regular time series with no exogenous regressors).}

\item{ci_level}{Confidence Interval levels for forecasting. Default value is 95.}

\item{negative_forecast}{Negative values are allowed for forecasting. Default value is TRUE. If FALSE, all negative values for forecasting are set to 0.}

\item{...}{Other arguments}
}
\value{
A vector of fitted residuals.
}
\description{
Forecast a model from the fable ATA model
}
\examples{
library(fable.ata)
as_tsibble(USAccDeaths) \%>\%
  model(ata = AutoATA(value ~ trend("A") + season("M"))) \%>\% forecast(h=24)

}
