% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{THETA}
\alias{THETA}
\title{Theta method}
\usage{
THETA(formula, ...)
}
\arguments{
\item{formula}{Model specification.}

\item{...}{Not used.}
}
\value{
A model specification.
}
\description{
The theta method of Assimakopoulos and Nikolopoulos (2000) is equivalent to
simple exponential smoothing with drift. This is demonstrated in Hyndman and
Billah (2003).
}
\details{
The series is tested for seasonality using the test outlined in A&N. If
deemed seasonal, the series is seasonally adjusted using a classical
multiplicative decomposition before applying the theta method. The resulting
forecasts are then reseasonalized.

More general theta methods are available in the forecTheta package.
}
\section{Specials}{


\subsection{season}{
The \code{season} special is used to specify the parameters of the seasonal adjustment via classical decomposition.
\preformatted{
window(period = NULL, method = c("multiplicative", "additive"))
}

\tabular{ll}{
\code{period} \tab The periodic nature of the seasonality. This can be either a number indicating the number of observations in each seasonal period, or text to indicate the duration of the seasonal window (for example, annual seasonality would be "1 year").  \cr
\code{method} \tab The type of classical decomposition to apply. The original Theta method always used multiplicative seasonal decomposition, and so this is the default.
}
}
}

\references{
Assimakopoulos, V. and Nikolopoulos, K. (2000). The theta model:
a decomposition approach to forecasting. \emph{International Journal of
Forecasting} \bold{16}, 521-530.

Hyndman, R.J., and Billah, B. (2003) Unmasking the Theta method.
\emph{International J. Forecasting}, \bold{19}, 287-290.
}
\author{
Rob J Hyndman, Mitchell O'Hara-Wild
}
