% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagwalk.R
\name{fitted.RW}
\alias{fitted.RW}
\title{Extract fitted values from a fable model}
\usage{
\method{fitted}{RW}(object, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{...}{Additional arguments for forecast model methods.}
}
\value{
A vector of fitted values.
}
\description{
Extracts the fitted values.
}
\examples{
as_tsibble(Nile) \%>\%
  model(NAIVE(value)) \%>\%
  fitted()

library(tsibbledata)
aus_production \%>\%
  model(snaive = SNAIVE(Beer ~ lag("year"))) \%>\%
  fitted()
}
